% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program fittingTvC.m
function [beta, gamma, Nm, Sa, r2] = fittingTvC(TvC)

data = TvC;
NperformanceLevels = size(TvC, 1) -1;
NnoiseLevels = size(TvC, 2) - 1;
guess = [4 2 0.1 0.01];   % beta, gamma, Nm, Sa
options = optimset('fminsearch');
[guess, L] = fminsearch('TvCcostfunc', guess, options, ...
     data);
beta = guess(1);
gamma = guess(2);
Nm = guess(3);
Sa = guess(4);
Log_observedThresholds = ...
    log(TvC(2:(NperformanceLevels+1), 2:(NnoiseLevels+1)));
meanT = mean(mean(Log_observedThresholds));
r2 = 1 - L/sum(sum((Log_observedThresholds - meanT).^2));



